# Machine Learning on Arduino
## TensorFlow Lite gesture training tutorial

In this tutorial we will teach a board to recognise gestures! We'll capture motion data from the [Arduino Nano 33 BLE Sense](https://store.arduino.cc/arduino-nano-33-ble-sense) board, import it into TensorFlow to train a model, and deploy a classifier onto the board using [TensorFlow Lite for microcontrollers](https://www.tensorflow.org/lite/microcontrollers/overview). 

### Credits

This tutorial is adapted from the [workshop](https://github.com/sandeepmistry/aimldevfest-workshop-2019) Sandeep Mistry, Arduino and Don Coleman, Chariot Solutions presented at AI/ML Devfest in September 2019. 




## Exercises

* [Exercise 1: Development Environment](exercises/exercise1.md)
* [Exercise 2: Connecting the Board](exercises/exercise2.md)
* [Exercise 3: Visualizing the IMU Data](exercises/exercise3.md)
* [Exercise 4: Gather the Training Data](exercises/exercise4.md)
* [Exercise 5: Machine Learning](exercises/exercise5.md)
* [Exercise 6: Classifying IMU Data](exercises/exercise6.md)
* [Exercise 7: Gesture Controlled USB Emoji Keyboard](exercises/exercise7.md)
* [Exercise 8: Next Steps](exercises/exercise8.md)


